/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api;

import java.util.DoubleSummaryStatistics;

import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;

/**
 * DoubleIterable is an interface which is memory-optimized for double primitives.
 * It is inspired by the interface RichIterable, and contains a subset of the internal iterator methods on RichIterable like collect, sum, etc.
 * The API also includes an external iterator method, which returns an DoubleIterator. DoubleIterator helps iterate over the DoubleIterable without boxing the primitives.
 * This file was automatically generated from template file primitiveIterable.stg.
 */
public interface DoubleIterable extends PrimitiveIterable
{
    DoubleIterator doubleIterator();

    double[] toArray();

    boolean contains(double value);

    boolean containsAll(double... source);

    boolean containsAll(DoubleIterable source);

    void forEach(DoubleProcedure procedure);

    /**
     * @since 7.0.
     */
    void each(DoubleProcedure procedure);

    DoubleIterable select(DoublePredicate predicate);

    DoubleIterable reject(DoublePredicate predicate);

    <V> RichIterable<V> collect(DoubleToObjectFunction<? extends V> function);

    double detectIfNone(DoublePredicate predicate, double ifNone);

    int count(DoublePredicate predicate);

    boolean anySatisfy(DoublePredicate predicate);

    boolean allSatisfy(DoublePredicate predicate);

    boolean noneSatisfy(DoublePredicate predicate);

    MutableDoubleList toList();

    MutableDoubleSet toSet();

    MutableDoubleBag toBag();

    LazyDoubleIterable asLazy();

    <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function);


    double sum();

    /**
     * @since 8.0
     */
    default DoubleSummaryStatistics summaryStatistics()
    {
        DoubleSummaryStatistics stats = new DoubleSummaryStatistics();
        this.forEach(stats::accept);
        return stats;
    }

    double max();

    double maxIfEmpty(double defaultValue);

    double min();

    double minIfEmpty(double defaultValue);

    double average();

    double median();

    double[] toSortedArray();

    MutableDoubleList toSortedList();
}
