/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.bag.primitive;

import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.collection.primitive.ImmutableByteCollection;

/**
 * This file was automatically generated from template file immutablePrimitiveBag.stg.
 *
 * @since 3.0.
 */
public interface ImmutableByteBag extends ImmutableByteCollection, ByteBag
{
    ImmutableByteBag select(BytePredicate predicate);

    ImmutableByteBag reject(BytePredicate predicate);

    <V> ImmutableBag<V> collect(ByteToObjectFunction<? extends V> function);

    ImmutableByteBag newWith(byte element);

    ImmutableByteBag newWithout(byte element);

    ImmutableByteBag newWithAll(ByteIterable elements);

    ImmutableByteBag newWithoutAll(ByteIterable elements);
}
