/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.bag.primitive;

import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;

/**
 * This file was automatically generated from template file mutablePrimitiveBag.stg.
 *
 * @since 3.0.
 */
public interface MutableBooleanBag extends MutableBooleanCollection, BooleanBag
{
    void addOccurrences(boolean item, int occurrences);

    boolean removeOccurrences(boolean item, int occurrences);

    MutableBooleanBag select(BooleanPredicate predicate);

    MutableBooleanBag reject(BooleanPredicate predicate);

    <V> MutableBag<V> collect(BooleanToObjectFunction<? extends V> function);

    MutableBooleanBag with(boolean element);

    MutableBooleanBag without(boolean element);

    MutableBooleanBag withAll(BooleanIterable elements);

    MutableBooleanBag withoutAll(BooleanIterable elements);

    MutableBooleanBag asUnmodifiable();

    MutableBooleanBag asSynchronized();

    /**
     * Returns an immutable copy of this bag.
     */
    ImmutableBooleanBag toImmutable();
}
