/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.bag.primitive;

import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;

/**
 * This file was automatically generated from template file mutablePrimitiveBag.stg.
 *
 * @since 3.0.
 */
public interface MutableByteBag extends MutableByteCollection, ByteBag
{
    void addOccurrences(byte item, int occurrences);

    boolean removeOccurrences(byte item, int occurrences);

    MutableByteBag select(BytePredicate predicate);

    MutableByteBag reject(BytePredicate predicate);

    <V> MutableBag<V> collect(ByteToObjectFunction<? extends V> function);

    MutableByteBag with(byte element);

    MutableByteBag without(byte element);

    MutableByteBag withAll(ByteIterable elements);

    MutableByteBag withoutAll(ByteIterable elements);

    MutableByteBag asUnmodifiable();

    MutableByteBag asSynchronized();

    /**
     * Returns an immutable copy of this bag.
     */
    ImmutableByteBag toImmutable();
}
