/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.factory.map.primitive;

import org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.ObjectDoubleMap;

/**
 * A factory which creates instances of type {@link MutableObjectDoubleMap}.
 * This file was automatically generated from template file mutableObjectPrimitiveMapFactory.stg.
 *
 * @since 6.0.
 */
public interface MutableObjectDoubleMapFactory
{
    <K> MutableObjectDoubleMap<K> empty();

    /**
     * Same as {@link #empty()}.
     */
    <K> MutableObjectDoubleMap<K> of();

    /**
     * Same as {@link #empty()}.
     */
    <K> MutableObjectDoubleMap<K> with();

    /**
     * Same as {@link #withAll(ObjectDoubleMap)}.
     */
    <K> MutableObjectDoubleMap<K> ofAll(ObjectDoubleMap<? extends K>  map);

    <K> MutableObjectDoubleMap<K> withAll(ObjectDoubleMap<? extends K>  map);
}
