/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.list.primitive;

import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.collection.primitive.ImmutableBooleanCollection;
import org.eclipse.collections.api.list.ImmutableList;

/**
 * This file was automatically generated from template file immutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface ImmutableBooleanList extends ImmutableBooleanCollection, BooleanList
{
    ImmutableBooleanList select(BooleanPredicate predicate);

    ImmutableBooleanList reject(BooleanPredicate predicate);

    <V> ImmutableList<V> collect(BooleanToObjectFunction<? extends V> function);

    ImmutableBooleanList newWith(boolean element);

    ImmutableBooleanList newWithout(boolean element);

    ImmutableBooleanList newWithAll(BooleanIterable elements);

    ImmutableBooleanList newWithoutAll(BooleanIterable elements);

    ImmutableBooleanList toReversed();

    /**
     * @since 6.0.
     */
    ImmutableBooleanList distinct();

    ImmutableBooleanList subList(int fromIndex, int toIndex);
}
