/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.list.primitive;

import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.collection.primitive.ImmutableCharCollection;
import org.eclipse.collections.api.list.ImmutableList;

/**
 * This file was automatically generated from template file immutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface ImmutableCharList extends ImmutableCharCollection, CharList
{
    ImmutableCharList select(CharPredicate predicate);

    ImmutableCharList reject(CharPredicate predicate);

    <V> ImmutableList<V> collect(CharToObjectFunction<? extends V> function);

    ImmutableCharList newWith(char element);

    ImmutableCharList newWithout(char element);

    ImmutableCharList newWithAll(CharIterable elements);

    ImmutableCharList newWithoutAll(CharIterable elements);

    ImmutableCharList toReversed();

    /**
     * @since 6.0.
     */
    ImmutableCharList distinct();

    ImmutableCharList subList(int fromIndex, int toIndex);
}
