/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.list.primitive;

import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.list.MutableList;

/**
 * This file was automatically generated from template file mutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface MutableBooleanList extends MutableBooleanCollection, BooleanList
{
    void addAtIndex(int index, boolean element);

    boolean addAllAtIndex(int index, boolean... source);

    boolean addAllAtIndex(int index, BooleanIterable source);

    boolean removeAtIndex(int index);

    boolean set(int index, boolean element);

    MutableBooleanList select(BooleanPredicate predicate);

    MutableBooleanList reject(BooleanPredicate predicate);

    MutableBooleanList with(boolean element);

    MutableBooleanList without(boolean element);

    MutableBooleanList withAll(BooleanIterable elements);

    MutableBooleanList withoutAll(BooleanIterable elements);

    <V> MutableList<V> collect(BooleanToObjectFunction<? extends V> function);

    MutableBooleanList reverseThis();

    MutableBooleanList toReversed();

    /**
     * @since 6.0.
     */
    MutableBooleanList distinct();

    MutableBooleanList asUnmodifiable();

    MutableBooleanList asSynchronized();

    /**
     * Returns an immutable copy of this list.
     */
    ImmutableBooleanList toImmutable();

    MutableBooleanList subList(int fromIndex, int toIndex);
}
