/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.list.primitive;

import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.list.MutableList;

/**
 * This file was automatically generated from template file mutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface MutableByteList extends MutableByteCollection, ByteList
{
    void addAtIndex(int index, byte element);

    boolean addAllAtIndex(int index, byte... source);

    boolean addAllAtIndex(int index, ByteIterable source);

    byte removeAtIndex(int index);

    byte set(int index, byte element);

    MutableByteList select(BytePredicate predicate);

    MutableByteList reject(BytePredicate predicate);

    MutableByteList with(byte element);

    MutableByteList without(byte element);

    MutableByteList withAll(ByteIterable elements);

    MutableByteList withoutAll(ByteIterable elements);

    <V> MutableList<V> collect(ByteToObjectFunction<? extends V> function);

    MutableByteList reverseThis();

    MutableByteList toReversed();

    /**
     * @since 6.0.
     */
    MutableByteList distinct();

    /**
     * Sorts this list mutating its contents and returns the same mutable list (this).
     */
    MutableByteList sortThis();

    MutableByteList asUnmodifiable();

    MutableByteList asSynchronized();

    /**
     * Returns an immutable copy of this list.
     */
    ImmutableByteList toImmutable();

    MutableByteList subList(int fromIndex, int toIndex);
}
