/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.list.primitive;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.list.MutableList;

/**
 * This file was automatically generated from template file mutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface MutableLongList extends MutableLongCollection, LongList
{
    void addAtIndex(int index, long element);

    boolean addAllAtIndex(int index, long... source);

    boolean addAllAtIndex(int index, LongIterable source);

    long removeAtIndex(int index);

    long set(int index, long element);

    MutableLongList select(LongPredicate predicate);

    MutableLongList reject(LongPredicate predicate);

    MutableLongList with(long element);

    MutableLongList without(long element);

    MutableLongList withAll(LongIterable elements);

    MutableLongList withoutAll(LongIterable elements);

    <V> MutableList<V> collect(LongToObjectFunction<? extends V> function);

    MutableLongList reverseThis();

    MutableLongList toReversed();

    /**
     * @since 6.0.
     */
    MutableLongList distinct();

    /**
     * Sorts this list mutating its contents and returns the same mutable list (this).
     */
    MutableLongList sortThis();

    MutableLongList asUnmodifiable();

    MutableLongList asSynchronized();

    /**
     * Returns an immutable copy of this list.
     */
    ImmutableLongList toImmutable();

    MutableLongList subList(int fromIndex, int toIndex);
}
