/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.list.primitive;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.list.MutableList;

/**
 * This file was automatically generated from template file mutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface MutableShortList extends MutableShortCollection, ShortList
{
    void addAtIndex(int index, short element);

    boolean addAllAtIndex(int index, short... source);

    boolean addAllAtIndex(int index, ShortIterable source);

    short removeAtIndex(int index);

    short set(int index, short element);

    MutableShortList select(ShortPredicate predicate);

    MutableShortList reject(ShortPredicate predicate);

    MutableShortList with(short element);

    MutableShortList without(short element);

    MutableShortList withAll(ShortIterable elements);

    MutableShortList withoutAll(ShortIterable elements);

    <V> MutableList<V> collect(ShortToObjectFunction<? extends V> function);

    MutableShortList reverseThis();

    MutableShortList toReversed();

    /**
     * @since 6.0.
     */
    MutableShortList distinct();

    /**
     * Sorts this list mutating its contents and returns the same mutable list (this).
     */
    MutableShortList sortThis();

    MutableShortList asUnmodifiable();

    MutableShortList asSynchronized();

    /**
     * Returns an immutable copy of this list.
     */
    ImmutableShortList toImmutable();

    MutableShortList subList(int fromIndex, int toIndex);
}
