/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.map.primitive;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableBooleanBag;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.predicate.primitive.FloatBooleanPredicate;

/**
 * This file was automatically generated from template file immutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface ImmutableFloatBooleanMap extends FloatBooleanMap
{
    ImmutableFloatBooleanMap select(FloatBooleanPredicate predicate);

    ImmutableFloatBooleanMap reject(FloatBooleanPredicate predicate);

    ImmutableBooleanBag select(BooleanPredicate predicate);

    ImmutableBooleanBag reject(BooleanPredicate predicate);

    <V> ImmutableBag<V> collect(BooleanToObjectFunction<? extends V> function);

    ImmutableFloatBooleanMap newWithKeyValue(float key, boolean value);

    ImmutableFloatBooleanMap newWithoutKey(float key);

    ImmutableFloatBooleanMap newWithoutAllKeys(FloatIterable keys);
}
