/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.set.primitive;

import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.collection.primitive.ImmutableDoubleCollection;
import org.eclipse.collections.api.set.ImmutableSet;

/**
 * This file was automatically generated from template file immutablePrimitiveSet.stg.
 *
 * @since 3.0.
 */
public interface ImmutableDoubleSet extends ImmutableDoubleCollection, DoubleSet
{
    ImmutableDoubleSet select(DoublePredicate predicate);

    ImmutableDoubleSet reject(DoublePredicate predicate);

    <V> ImmutableSet<V> collect(DoubleToObjectFunction<? extends V> function);

    ImmutableDoubleSet newWith(double element);

    ImmutableDoubleSet newWithout(double element);

    ImmutableDoubleSet newWithAll(DoubleIterable elements);

    ImmutableDoubleSet newWithoutAll(DoubleIterable elements);
}
