/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.bag.primitive;

import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.tuple.primitive.CharIntPair;

/**
 * This file was automatically generated from template file mutablePrimitiveBag.stg.
 *
 * @since 3.0.
 */
public interface MutableCharBag extends MutableCharCollection, CharBag
{
    void addOccurrences(char item, int occurrences);

    boolean removeOccurrences(char item, int occurrences);

    /**
     * Returns all elements of the bag that have a number of occurrences that satisfy the predicate.
     *
     * @since 8.0
     */
    MutableCharBag selectByOccurrences(IntPredicate predicate);

    /**
     * Returns the {@code count} most frequently occurring items.
     *
     * In the event of a tie, all of the items with the number of occurrences that match the occurrences of the last
     * item will be returned.
     *
     * @since 8.0
     */
    MutableList<CharIntPair> topOccurrences(int count);

    /**
     * Returns the {@code count} least frequently occurring items.
     *
     * In the event of a tie, all of the items with the number of occurrences that match the occurrences of the last
     * item will be returned.
     *
     * @since 8.0
     */
    MutableList<CharIntPair> bottomOccurrences(int count);

    MutableCharBag select(CharPredicate predicate);

    MutableCharBag reject(CharPredicate predicate);

    <V> MutableBag<V> collect(CharToObjectFunction<? extends V> function);

    MutableCharBag with(char element);

    MutableCharBag without(char element);

    MutableCharBag withAll(CharIterable elements);

    MutableCharBag withoutAll(CharIterable elements);

    MutableCharBag asUnmodifiable();

    MutableCharBag asSynchronized();

    /**
     * Returns an immutable copy of this bag.
     */
    ImmutableCharBag toImmutable();
}
