/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.list.primitive;

import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.collection.primitive.ImmutableDoubleCollection;
import org.eclipse.collections.api.list.ImmutableList;

/**
 * This file was automatically generated from template file immutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface ImmutableDoubleList extends ImmutableDoubleCollection, DoubleList
{
    ImmutableDoubleList select(DoublePredicate predicate);

    ImmutableDoubleList reject(DoublePredicate predicate);

    <V> ImmutableList<V> collect(DoubleToObjectFunction<? extends V> function);

    ImmutableDoubleList newWith(double element);

    ImmutableDoubleList newWithout(double element);

    ImmutableDoubleList newWithAll(DoubleIterable elements);

    ImmutableDoubleList newWithoutAll(DoubleIterable elements);

    ImmutableDoubleList toReversed();

    /**
     * @since 6.0.
     */
    ImmutableDoubleList distinct();

    ImmutableDoubleList subList(int fromIndex, int toIndex);
}
