/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.list.primitive;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.list.MutableList;

/**
 * This file was automatically generated from template file mutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface MutableFloatList extends MutableFloatCollection, FloatList
{
    void addAtIndex(int index, float element);

    boolean addAllAtIndex(int index, float... source);

    boolean addAllAtIndex(int index, FloatIterable source);

    float removeAtIndex(int index);

    float set(int index, float element);

    MutableFloatList select(FloatPredicate predicate);

    MutableFloatList reject(FloatPredicate predicate);

    MutableFloatList with(float element);

    MutableFloatList without(float element);

    MutableFloatList withAll(FloatIterable elements);

    MutableFloatList withoutAll(FloatIterable elements);

    <V> MutableList<V> collect(FloatToObjectFunction<? extends V> function);

    MutableFloatList reverseThis();

    MutableFloatList toReversed();

    /**
     * @since 6.0.
     */
    MutableFloatList distinct();

    /**
     * Sorts this list mutating its contents and returns the same mutable list (this).
     */
    MutableFloatList sortThis();

    MutableFloatList asUnmodifiable();

    MutableFloatList asSynchronized();

    /**
     * Returns an immutable copy of this list.
     */
    ImmutableFloatList toImmutable();

    MutableFloatList subList(int fromIndex, int toIndex);
}
