/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.set.primitive;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.set.MutableSet;

/**
 * This file was automatically generated from template file mutablePrimitiveSet.stg.
 *
 * @since 3.0.
 */
public interface MutableShortSet extends MutableShortCollection, ShortSet
{
    MutableShortSet select(ShortPredicate predicate);

    MutableShortSet reject(ShortPredicate predicate);

    <V> MutableSet<V> collect(ShortToObjectFunction<? extends V> function);

    MutableShortSet with(short element);

    MutableShortSet without(short element);

    MutableShortSet withAll(ShortIterable elements);

    MutableShortSet withoutAll(ShortIterable elements);

    MutableShortSet asUnmodifiable();

    MutableShortSet asSynchronized();

    /**
     * Returns a frozen copy of this set. A frozen copy is the same thing as an immutable copy without safe-publish guarantees.
     */
    ShortSet freeze();

    /**
     * Returns an immutable copy of this set.
     */
    ImmutableShortSet toImmutable();
}
