/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.stack.primitive;

import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.stack.ImmutableStack;

/**
 * This file was automatically generated from template file immutablePrimitiveStack.stg.
 *
 * @since 3.0.
 */
public interface ImmutableDoubleStack extends DoubleStack
{
    ImmutableDoubleStack push(double item);

    ImmutableDoubleStack pop();

    ImmutableDoubleStack pop(int count);

    ImmutableDoubleStack select(DoublePredicate predicate);

    ImmutableDoubleStack reject(DoublePredicate predicate);

    <V> ImmutableStack<V> collect(DoubleToObjectFunction<? extends V> function);
}
