/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api;

import java.util.IntSummaryStatistics;

import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.set.primitive.MutableShortSet;

/**
 * ShortIterable is an interface which is memory-optimized for short primitives.
 * It is inspired by the interface RichIterable, and contains a subset of the internal iterator methods on RichIterable like collect, sum, etc.
 * The API also includes an external iterator method, which returns an ShortIterator. ShortIterator helps iterate over the ShortIterable without boxing the primitives.
 * This file was automatically generated from template file primitiveIterable.stg.
 */
public interface ShortIterable extends PrimitiveIterable
{
    ShortIterator shortIterator();

    short[] toArray();

    boolean contains(short value);

    boolean containsAll(short... source);

    boolean containsAll(ShortIterable source);

    void forEach(ShortProcedure procedure);

    /**
     * @since 7.0.
     */
    void each(ShortProcedure procedure);

    ShortIterable select(ShortPredicate predicate);

    ShortIterable reject(ShortPredicate predicate);

    <V> RichIterable<V> collect(ShortToObjectFunction<? extends V> function);

    short detectIfNone(ShortPredicate predicate, short ifNone);

    int count(ShortPredicate predicate);

    boolean anySatisfy(ShortPredicate predicate);

    boolean allSatisfy(ShortPredicate predicate);

    boolean noneSatisfy(ShortPredicate predicate);

    MutableShortList toList();

    MutableShortSet toSet();

    MutableShortBag toBag();

    LazyShortIterable asLazy();

    <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function);


    long sum();

    /**
     * @since 8.0
     */
    default IntSummaryStatistics summaryStatistics()
    {
        IntSummaryStatistics stats = new IntSummaryStatistics();
        this.forEach(stats::accept);
        return stats;
    }

    short max();

    short maxIfEmpty(short defaultValue);

    short min();

    short minIfEmpty(short defaultValue);

    double average();

    double median();

    short[] toSortedArray();

    MutableShortList toSortedList();
}
