/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.list.primitive;

import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.collection.primitive.ImmutableByteCollection;
import org.eclipse.collections.api.list.ImmutableList;

/**
 * This file was automatically generated from template file immutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface ImmutableByteList extends ImmutableByteCollection, ByteList
{
    ImmutableByteList select(BytePredicate predicate);

    ImmutableByteList reject(BytePredicate predicate);

    <V> ImmutableList<V> collect(ByteToObjectFunction<? extends V> function);

    ImmutableByteList newWith(byte element);

    ImmutableByteList newWithout(byte element);

    ImmutableByteList newWithAll(ByteIterable elements);

    ImmutableByteList newWithoutAll(ByteIterable elements);

    ImmutableByteList toReversed();

    /**
     * @since 6.0.
     */
    ImmutableByteList distinct();

    ImmutableByteList subList(int fromIndex, int toIndex);
}
