/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.stack.primitive;

import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.list.primitive.FloatList;
import org.eclipse.collections.api.stack.MutableStack;

/**
 * This file was automatically generated from template file mutablePrimitiveStack.stg.
 *
 * @since 3.0.
 */
public interface MutableFloatStack extends FloatStack
{
    /**
     * Adds an item to the top of the stack.
     */
    void push(float item);

    /**
     * Removes and returns the top element of the stack.
     */
    float pop();

    /**
     * Removes and returns a FloatList of the number of elements specified by the count, beginning with the top of the stack.
     */
    FloatList pop(int count);

    /**
     * Clears the Stack
     */
    void clear();

    MutableFloatStack select(FloatPredicate predicate);

    MutableFloatStack reject(FloatPredicate predicate);

    <V> MutableStack<V> collect(FloatToObjectFunction<? extends V> function);

    MutableFloatStack asUnmodifiable();

    MutableFloatStack asSynchronized();
}
