/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api;

import java.util.IntSummaryStatistics;

import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.set.primitive.MutableCharSet;

/**
 * CharIterable is an interface which is memory-optimized for char primitives.
 * It is inspired by the interface RichIterable, and contains a subset of the internal iterator methods on RichIterable like collect, sum, etc.
 * The API also includes an external iterator method, which returns an CharIterator. CharIterator helps iterate over the CharIterable without boxing the primitives.
 * This file was automatically generated from template file primitiveIterable.stg.
 */
public interface CharIterable extends PrimitiveIterable
{
    CharIterator charIterator();

    char[] toArray();

    boolean contains(char value);

    boolean containsAll(char... source);

    boolean containsAll(CharIterable source);

    void forEach(CharProcedure procedure);

    /**
     * @since 7.0.
     */
    void each(CharProcedure procedure);

    CharIterable select(CharPredicate predicate);

    CharIterable reject(CharPredicate predicate);

    <V> RichIterable<V> collect(CharToObjectFunction<? extends V> function);

    char detectIfNone(CharPredicate predicate, char ifNone);

    int count(CharPredicate predicate);

    boolean anySatisfy(CharPredicate predicate);

    boolean allSatisfy(CharPredicate predicate);

    boolean noneSatisfy(CharPredicate predicate);

    MutableCharList toList();

    MutableCharSet toSet();

    MutableCharBag toBag();

    LazyCharIterable asLazy();

    <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function);


    long sum();

    /**
     * @since 8.0
     */
    default IntSummaryStatistics summaryStatistics()
    {
        IntSummaryStatistics stats = new IntSummaryStatistics();
        this.forEach(stats::accept);
        return stats;
    }

    char max();

    char maxIfEmpty(char defaultValue);

    char min();

    char minIfEmpty(char defaultValue);

    double average();

    double median();

    char[] toSortedArray();

    MutableCharList toSortedList();
}
