/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api;

import java.util.IntSummaryStatistics;

import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.primitive.MutableIntSet;

/**
 * IntIterable is an interface which is memory-optimized for int primitives.
 * It is inspired by the interface RichIterable, and contains a subset of the internal iterator methods on RichIterable like collect, sum, etc.
 * The API also includes an external iterator method, which returns an IntIterator. IntIterator helps iterate over the IntIterable without boxing the primitives.
 * This file was automatically generated from template file primitiveIterable.stg.
 */
public interface IntIterable extends PrimitiveIterable
{
    IntIterator intIterator();

    int[] toArray();

    boolean contains(int value);

    boolean containsAll(int... source);

    boolean containsAll(IntIterable source);

    void forEach(IntProcedure procedure);

    /**
     * @since 7.0.
     */
    void each(IntProcedure procedure);

    IntIterable select(IntPredicate predicate);

    IntIterable reject(IntPredicate predicate);

    <V> RichIterable<V> collect(IntToObjectFunction<? extends V> function);

    int detectIfNone(IntPredicate predicate, int ifNone);

    int count(IntPredicate predicate);

    boolean anySatisfy(IntPredicate predicate);

    boolean allSatisfy(IntPredicate predicate);

    boolean noneSatisfy(IntPredicate predicate);

    MutableIntList toList();

    MutableIntSet toSet();

    MutableIntBag toBag();

    LazyIntIterable asLazy();

    <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function);


    long sum();

    /**
     * @since 8.0
     */
    default IntSummaryStatistics summaryStatistics()
    {
        IntSummaryStatistics stats = new IntSummaryStatistics();
        this.forEach(stats::accept);
        return stats;
    }

    int max();

    int maxIfEmpty(int defaultValue);

    int min();

    int minIfEmpty(int defaultValue);

    double average();

    double median();

    int[] toSortedArray();

    MutableIntList toSortedList();
}
