/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api;

import java.util.LongSummaryStatistics;

import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;

/**
 * LongIterable is an interface which is memory-optimized for long primitives.
 * It is inspired by the interface RichIterable, and contains a subset of the internal iterator methods on RichIterable like collect, sum, etc.
 * The API also includes an external iterator method, which returns an LongIterator. LongIterator helps iterate over the LongIterable without boxing the primitives.
 * This file was automatically generated from template file primitiveIterable.stg.
 */
public interface LongIterable extends PrimitiveIterable
{
    LongIterator longIterator();

    long[] toArray();

    boolean contains(long value);

    boolean containsAll(long... source);

    boolean containsAll(LongIterable source);

    void forEach(LongProcedure procedure);

    /**
     * @since 7.0.
     */
    void each(LongProcedure procedure);

    LongIterable select(LongPredicate predicate);

    LongIterable reject(LongPredicate predicate);

    <V> RichIterable<V> collect(LongToObjectFunction<? extends V> function);

    long detectIfNone(LongPredicate predicate, long ifNone);

    int count(LongPredicate predicate);

    boolean anySatisfy(LongPredicate predicate);

    boolean allSatisfy(LongPredicate predicate);

    boolean noneSatisfy(LongPredicate predicate);

    MutableLongList toList();

    MutableLongSet toSet();

    MutableLongBag toBag();

    LazyLongIterable asLazy();

    <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function);


    long sum();

    /**
     * @since 8.0
     */
    default LongSummaryStatistics summaryStatistics()
    {
        LongSummaryStatistics stats = new LongSummaryStatistics();
        this.forEach(stats::accept);
        return stats;
    }

    long max();

    long maxIfEmpty(long defaultValue);

    long min();

    long minIfEmpty(long defaultValue);

    double average();

    double median();

    long[] toSortedArray();

    MutableLongList toSortedList();
}
