/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.bag.primitive;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.tuple.primitive.LongIntPair;

/**
 * This file was automatically generated from template file mutablePrimitiveBag.stg.
 *
 * @since 3.0.
 */
public interface MutableLongBag extends MutableLongCollection, LongBag
{
    void addOccurrences(long item, int occurrences);

    boolean removeOccurrences(long item, int occurrences);

    /**
     * Returns all elements of the bag that have a number of occurrences that satisfy the predicate.
     *
     * @since 8.0
     */
    MutableLongBag selectByOccurrences(IntPredicate predicate);

    /**
     * Returns the {@code count} most frequently occurring items.
     *
     * In the event of a tie, all of the items with the number of occurrences that match the occurrences of the last
     * item will be returned.
     *
     * @since 8.0
     */
    MutableList<LongIntPair> topOccurrences(int count);

    /**
     * Returns the {@code count} least frequently occurring items.
     *
     * In the event of a tie, all of the items with the number of occurrences that match the occurrences of the last
     * item will be returned.
     *
     * @since 8.0
     */
    MutableList<LongIntPair> bottomOccurrences(int count);

    MutableLongBag select(LongPredicate predicate);

    MutableLongBag reject(LongPredicate predicate);

    <V> MutableBag<V> collect(LongToObjectFunction<? extends V> function);

    MutableLongBag with(long element);

    MutableLongBag without(long element);

    MutableLongBag withAll(LongIterable elements);

    MutableLongBag withoutAll(LongIterable elements);

    MutableLongBag asUnmodifiable();

    MutableLongBag asSynchronized();

    /**
     * Returns an immutable copy of this bag.
     */
    ImmutableLongBag toImmutable();
}
