/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.factory.map.primitive;

import org.eclipse.collections.api.map.primitive.MutableIntCharMap;
import org.eclipse.collections.api.map.primitive.IntCharMap;

/**
 * A factory which creates instances of type {@link MutableIntCharMap}.
 * This file was automatically generated from template file mutablePrimitivePrimitiveMapFactory.stg.
 *
 * @since 6.0.
 */
public interface MutableIntCharMapFactory
{
    MutableIntCharMap empty();

    /**
     * Same as {@link #empty()}.
     */
    MutableIntCharMap of();

    /**
     * Same as {@link #empty()}.
     */
    MutableIntCharMap with();

    /**
     * Same as {@link #withAll(IntCharMap)}.
     */
    MutableIntCharMap ofAll(IntCharMap map);

    MutableIntCharMap withAll(IntCharMap map);
}
