/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.list.primitive;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.collection.primitive.ImmutableShortCollection;
import org.eclipse.collections.api.list.ImmutableList;

/**
 * This file was automatically generated from template file immutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface ImmutableShortList extends ImmutableShortCollection, ShortList
{
    ImmutableShortList select(ShortPredicate predicate);

    ImmutableShortList reject(ShortPredicate predicate);

    <V> ImmutableList<V> collect(ShortToObjectFunction<? extends V> function);

    ImmutableShortList newWith(short element);

    ImmutableShortList newWithout(short element);

    ImmutableShortList newWithAll(ShortIterable elements);

    ImmutableShortList newWithoutAll(ShortIterable elements);

    ImmutableShortList toReversed();

    /**
     * @since 6.0.
     */
    ImmutableShortList distinct();

    ImmutableShortList subList(int fromIndex, int toIndex);
}
