/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.map.primitive;

import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntFloatPredicate;

/**
 * This file was automatically generated from template file immutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface ImmutableIntFloatMap extends IntFloatMap
{
    ImmutableIntFloatMap select(IntFloatPredicate predicate);

    ImmutableIntFloatMap reject(IntFloatPredicate predicate);

    ImmutableFloatBag select(FloatPredicate predicate);

    ImmutableFloatBag reject(FloatPredicate predicate);

    <V> ImmutableBag<V> collect(FloatToObjectFunction<? extends V> function);

    ImmutableIntFloatMap newWithKeyValue(int key, float value);

    ImmutableIntFloatMap newWithoutKey(int key);

    ImmutableIntFloatMap newWithoutAllKeys(IntIterable keys);
}
