/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.map.primitive;

import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction0;
import org.eclipse.collections.api.block.function.primitive.BooleanToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectBooleanPredicate;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.iterator.MutableBooleanIterator;

/**
 * This file was automatically generated from template file mutableObjectPrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableObjectBooleanMap<K> extends ObjectBooleanMap<K>
{
    MutableBooleanIterator booleanIterator();

    void clear();

    void put(K key, boolean value);

    void putAll(ObjectBooleanMap<? extends K> map);

    void removeKey(K key);

    void remove(Object key);

    boolean removeKeyIfAbsent(K key, boolean value);

    boolean getIfAbsentPut(K key, boolean value);

    boolean getIfAbsentPut(K key, BooleanFunction0 function);

    boolean getIfAbsentPutWithKey(K key, BooleanFunction<? super K> function);

    <P> boolean getIfAbsentPutWith(K key, BooleanFunction<? super P> function, P parameter);

    boolean updateValue(K key, boolean initialValueIfAbsent, BooleanToBooleanFunction function);

    MutableObjectBooleanMap<K> select(ObjectBooleanPredicate<? super K> predicate);

    MutableObjectBooleanMap<K> reject(ObjectBooleanPredicate<? super K> predicate);

    MutableBooleanCollection select(BooleanPredicate predicate);

    MutableBooleanCollection reject(BooleanPredicate predicate);

    <V> MutableCollection<V> collect(BooleanToObjectFunction<? extends V> function);

    MutableObjectBooleanMap<K> withKeyValue(K key, boolean value);

    MutableObjectBooleanMap<K> withoutKey(K key);

    MutableObjectBooleanMap<K> withoutAllKeys(Iterable<? extends K> keys);

    MutableObjectBooleanMap<K> asUnmodifiable();

    MutableObjectBooleanMap<K> asSynchronized();
}
