/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.collection.primitive;

import java.util.Collection;

import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.iterator.MutableBooleanIterator;
import org.eclipse.collections.api.collection.MutableCollection;

/**
 * This file was automatically generated from template file mutablePrimitiveCollection.stg.
 *
 * @since 3.0.
 */
public interface MutableBooleanCollection extends BooleanIterable
{
    MutableBooleanIterator booleanIterator();

    boolean add(boolean element);

    boolean addAll(boolean... source);

    boolean addAll(BooleanIterable source);

    boolean remove(boolean value);

    boolean removeAll(BooleanIterable source);

    boolean removeAll(boolean... source);

    /**
     * @see Collection#retainAll(Collection)
     * @since 5.0
     */
    boolean retainAll(BooleanIterable elements);

    /**
     * @see Collection#retainAll(Collection)
     * @since 5.0
     */
    boolean retainAll(boolean... source);

    void clear();

    MutableBooleanCollection select(BooleanPredicate predicate);

    MutableBooleanCollection reject(BooleanPredicate predicate);

    <V> MutableCollection<V> collect(BooleanToObjectFunction<? extends V> function);

    MutableBooleanCollection with(boolean element);

    MutableBooleanCollection without(boolean element);

    MutableBooleanCollection withAll(BooleanIterable elements);

    MutableBooleanCollection withoutAll(BooleanIterable elements);

    MutableBooleanCollection asUnmodifiable();

    MutableBooleanCollection asSynchronized();

    ImmutableBooleanCollection toImmutable();
}
