/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.map.primitive;

import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ByteIntPredicate;

/**
 * This file was automatically generated from template file immutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface ImmutableByteIntMap extends ByteIntMap
{
    ImmutableByteIntMap select(ByteIntPredicate predicate);

    ImmutableByteIntMap reject(ByteIntPredicate predicate);

    ImmutableIntBag select(IntPredicate predicate);

    ImmutableIntBag reject(IntPredicate predicate);

    <V> ImmutableBag<V> collect(IntToObjectFunction<? extends V> function);

    ImmutableByteIntMap newWithKeyValue(byte key, int value);

    ImmutableByteIntMap newWithoutKey(byte key);

    ImmutableByteIntMap newWithoutAllKeys(ByteIterable keys);
}
