/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.list.primitive;

import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.list.MutableList;

/**
 * This file was automatically generated from template file mutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface MutableCharList extends MutableCharCollection, CharList
{
    void addAtIndex(int index, char element);

    boolean addAllAtIndex(int index, char... source);

    boolean addAllAtIndex(int index, CharIterable source);

    char removeAtIndex(int index);

    char set(int index, char element);

    MutableCharList select(CharPredicate predicate);

    MutableCharList reject(CharPredicate predicate);

    MutableCharList with(char element);

    MutableCharList without(char element);

    MutableCharList withAll(CharIterable elements);

    MutableCharList withoutAll(CharIterable elements);

    <V> MutableList<V> collect(CharToObjectFunction<? extends V> function);

    MutableCharList reverseThis();

    MutableCharList toReversed();

    /**
     * @since 6.0.
     */
    MutableCharList distinct();

    /**
     * Sorts this list mutating its contents and returns the same mutable list (this).
     */
    MutableCharList sortThis();

    MutableCharList asUnmodifiable();

    MutableCharList asSynchronized();

    /**
     * Returns an immutable copy of this list.
     */
    ImmutableCharList toImmutable();

    MutableCharList subList(int fromIndex, int toIndex);
}
