/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.set.primitive;

import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.set.MutableSet;

/**
 * This file was automatically generated from template file mutablePrimitiveSet.stg.
 *
 * @since 3.0.
 */
public interface MutableCharSet extends MutableCharCollection, CharSet
{
    MutableCharSet select(CharPredicate predicate);

    MutableCharSet reject(CharPredicate predicate);

    <V> MutableSet<V> collect(CharToObjectFunction<? extends V> function);

    MutableCharSet with(char element);

    MutableCharSet without(char element);

    MutableCharSet withAll(CharIterable elements);

    MutableCharSet withoutAll(CharIterable elements);

    MutableCharSet asUnmodifiable();

    MutableCharSet asSynchronized();

    /**
     * Returns a frozen copy of this set. A frozen copy is the same thing as an immutable copy without safe-publish guarantees.
     */
    CharSet freeze();

    /**
     * Returns an immutable copy of this set.
     */
    ImmutableCharSet toImmutable();
}
