/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.factory.map.primitive.MutableDoubleObjectMapFactory;
import org.eclipse.collections.api.map.primitive.DoubleObjectMap;
import org.eclipse.collections.api.map.primitive.MutableDoubleObjectMap;
import org.eclipse.collections.impl.factory.primitive.DoubleObjectMaps;
import org.eclipse.collections.impl.map.mutable.primitive.DoubleObjectHashMap;
import org.eclipse.collections.impl.utility.Iterate;

public enum MutableDoubleObjectMapFactoryImpl implements MutableDoubleObjectMapFactory
{
    INSTANCE;


    public <V> MutableDoubleObjectMap<V> empty() {
        return new DoubleObjectHashMap(0);
    }

    public <V> MutableDoubleObjectMap<V> of() {
        return this.empty();
    }

    public <V> MutableDoubleObjectMap<V> with() {
        return this.empty();
    }

    public <V> MutableDoubleObjectMap<V> ofAll(DoubleObjectMap<? extends V> map) {
        return this.withAll(map);
    }

    public <V> MutableDoubleObjectMap<V> withAll(DoubleObjectMap<? extends V> map) {
        if (map.isEmpty()) {
            return this.empty();
        }
        return new DoubleObjectHashMap<V>(map);
    }

    public <T, V> MutableDoubleObjectMap<V> from(Iterable<T> iterable, DoubleFunction<? super T> keyFunction, Function<? super T, ? extends V> valueFunction) {
        MutableDoubleObjectMap map = DoubleObjectMaps.mutable.empty();
        Iterate.forEach(iterable, (Procedure & Serializable)each -> map.put(keyFunction.doubleValueOf(each), valueFunction.valueOf(each)));
        return map;
    }
}

