/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable.primitive;

import java.util.stream.LongStream;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.factory.list.primitive.MutableLongListFactory;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.utility.Iterate;

public enum MutableLongListFactoryImpl implements MutableLongListFactory
{
    INSTANCE;


    public MutableLongList empty() {
        return new LongArrayList();
    }

    public MutableLongList of() {
        return this.empty();
    }

    public MutableLongList with() {
        return this.empty();
    }

    public MutableLongList withInitialCapacity(int capacity) {
        return new LongArrayList(capacity);
    }

    public MutableLongList of(long ... items) {
        return this.with(items);
    }

    public MutableLongList with(long ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        return LongArrayList.newListWith(items);
    }

    public MutableLongList ofAll(LongIterable items) {
        return this.withAll(items);
    }

    public MutableLongList withAll(LongIterable items) {
        return LongArrayList.newList(items);
    }

    public MutableLongList ofAll(Iterable<Long> iterable) {
        return this.withAll(iterable);
    }

    public MutableLongList withAll(Iterable<Long> iterable) {
        return Iterate.collectLong(iterable, Long::longValue, LongLists.mutable.empty());
    }

    public MutableLongList ofAll(LongStream items) {
        return this.withAll(items);
    }

    public MutableLongList withAll(LongStream items) {
        return this.with(items.toArray());
    }
}

