/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable.primitive;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.RandomAccess;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.list.mutable.AbstractMutableList;
import org.eclipse.collections.impl.utility.Iterate;

public class BoxedMutableLongList
extends AbstractMutableList<Long>
implements MutableList<Long>,
RandomAccess {
    private final MutableLongList delegate;

    public BoxedMutableLongList(MutableLongList delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean add(Long item) {
        return this.delegate.add(item.longValue());
    }

    public boolean addAll(int index, Collection<? extends Long> c) {
        long[] target = new long[c.size()];
        Iterate.forEachWithIndex(c, (ObjectIntProcedure & Serializable)(each, parameter) -> {
            target[parameter] = each;
        });
        return this.delegate.addAllAtIndex(index, target);
    }

    public void clear() {
        this.delegate.clear();
    }

    public Long get(int index) {
        return this.delegate.get(index);
    }

    public Long set(int index, Long element) {
        return this.delegate.set(index, element.longValue());
    }

    public void add(int index, Long element) {
        this.delegate.addAtIndex(index, element.longValue());
    }

    public Long remove(int index) {
        return this.delegate.removeAtIndex(index);
    }

    @Override
    public int indexOf(Object o) {
        return o instanceof Long ? this.delegate.indexOf(((Long)o).longValue()) : -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return o instanceof Long ? this.delegate.lastIndexOf(((Long)o).longValue()) : -1;
    }

    @Override
    public MutableList<Long> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex).boxed();
    }
}

