/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.mutable;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collection;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectIntPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.factory.Bags;
import org.eclipse.collections.api.factory.primitive.ObjectLongMaps;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.partition.bag.PartitionMutableBag;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.primitive.ObjectIntPair;
import org.eclipse.collections.impl.bag.mutable.SynchronizedBag;
import org.eclipse.collections.impl.collection.mutable.AbstractUnmodifiableMutableCollection;

public class UnmodifiableBag<T>
extends AbstractUnmodifiableMutableCollection<T>
implements MutableBag<T>,
Serializable {
    UnmodifiableBag(MutableBag<? extends T> mutableBag) {
        super(mutableBag);
    }

    public static <E, B extends MutableBag<E>> UnmodifiableBag<E> of(B bag) {
        if (bag == null) {
            throw new IllegalArgumentException("cannot create an UnmodifiableBag for null");
        }
        return new UnmodifiableBag(bag);
    }

    protected MutableBag<T> getMutableBag() {
        return (MutableBag)this.getMutableCollection();
    }

    @Override
    public MutableBag<T> asUnmodifiable() {
        return this;
    }

    @Override
    public MutableBag<T> asSynchronized() {
        return SynchronizedBag.of(this);
    }

    @Override
    public ImmutableBag<T> toImmutable() {
        return Bags.immutable.withAll((Iterable)((Object)this));
    }

    public boolean equals(Object obj) {
        return this.getMutableBag().equals(obj);
    }

    public int hashCode() {
        return this.getMutableBag().hashCode();
    }

    public String toStringOfItemToCount() {
        return this.getMutableBag().toStringOfItemToCount();
    }

    @Override
    public MutableBag<T> newEmpty() {
        return this.getMutableBag().newEmpty();
    }

    public MutableBag<T> selectByOccurrences(IntPredicate predicate) {
        return this.getMutableBag().selectByOccurrences(predicate);
    }

    @Override
    public MutableBag<T> tap(Procedure<? super T> procedure) {
        this.forEach(procedure);
        return this;
    }

    @Override
    public MutableBag<T> select(Predicate<? super T> predicate) {
        return this.getMutableBag().select(predicate);
    }

    @Override
    public <P> MutableBag<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.getMutableBag().selectWith(predicate, parameter);
    }

    @Override
    public MutableBag<T> reject(Predicate<? super T> predicate) {
        return this.getMutableBag().reject(predicate);
    }

    @Override
    public <P> MutableBag<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.getMutableBag().rejectWith(predicate, parameter);
    }

    @Override
    public PartitionMutableBag<T> partition(Predicate<? super T> predicate) {
        return this.getMutableBag().partition(predicate);
    }

    @Override
    public <P> PartitionMutableBag<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.getMutableBag().partitionWith(predicate, parameter);
    }

    @Override
    public <S> MutableBag<S> selectInstancesOf(Class<S> clazz) {
        return this.getMutableBag().selectInstancesOf(clazz);
    }

    @Override
    public <V> MutableBag<V> collect(Function<? super T, ? extends V> function) {
        return this.getMutableBag().collect(function);
    }

    public MutableBooleanBag collectBoolean(BooleanFunction<? super T> booleanFunction) {
        return this.getMutableBag().collectBoolean(booleanFunction);
    }

    public MutableByteBag collectByte(ByteFunction<? super T> byteFunction) {
        return this.getMutableBag().collectByte(byteFunction);
    }

    public MutableCharBag collectChar(CharFunction<? super T> charFunction) {
        return this.getMutableBag().collectChar(charFunction);
    }

    public MutableDoubleBag collectDouble(DoubleFunction<? super T> doubleFunction) {
        return this.getMutableBag().collectDouble(doubleFunction);
    }

    public MutableFloatBag collectFloat(FloatFunction<? super T> floatFunction) {
        return this.getMutableBag().collectFloat(floatFunction);
    }

    public MutableIntBag collectInt(IntFunction<? super T> intFunction) {
        return this.getMutableBag().collectInt(intFunction);
    }

    public MutableLongBag collectLong(LongFunction<? super T> longFunction) {
        return this.getMutableBag().collectLong(longFunction);
    }

    public MutableShortBag collectShort(ShortFunction<? super T> shortFunction) {
        return this.getMutableBag().collectShort(shortFunction);
    }

    @Override
    public <V> MutableBag<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return this.getMutableBag().flatCollect(function);
    }

    public MutableList<ObjectIntPair<T>> topOccurrences(int count) {
        return this.getMutableBag().topOccurrences(count);
    }

    public MutableList<ObjectIntPair<T>> bottomOccurrences(int count) {
        return this.getMutableBag().bottomOccurrences(count);
    }

    public <V> MutableBag<V> collectWithOccurrences(ObjectIntToObjectFunction<? super T, ? extends V> function) {
        return (MutableBag)this.getMutableBag().collectWithOccurrences(function, (Collection)Bags.mutable.empty());
    }

    @Override
    public <P, A> MutableBag<A> collectWith(Function2<? super T, ? super P, ? extends A> function, P parameter) {
        return this.getMutableBag().collectWith(function, parameter);
    }

    @Override
    public <V> MutableBag<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return this.getMutableBag().collectIf(predicate, function);
    }

    @Override
    public <V> MutableBagMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return this.getMutableBag().groupBy(function);
    }

    @Override
    public <V> MutableBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.getMutableBag().groupByEach(function);
    }

    public int addOccurrences(T item, int occurrences) {
        throw new UnsupportedOperationException("Cannot call addOccurrences() on " + this.getClass().getSimpleName());
    }

    public boolean removeOccurrences(Object item, int occurrences) {
        throw new UnsupportedOperationException("Cannot call removeOccurrences() on " + this.getClass().getSimpleName());
    }

    public boolean setOccurrences(T item, int occurrences) {
        throw new UnsupportedOperationException("Cannot call setOccurrences() on " + this.getClass().getSimpleName());
    }

    public int sizeDistinct() {
        return this.getMutableBag().sizeDistinct();
    }

    public int occurrencesOf(Object item) {
        return this.getMutableBag().occurrencesOf(item);
    }

    public void forEachWithOccurrences(ObjectIntProcedure<? super T> objectIntProcedure) {
        this.getMutableBag().forEachWithOccurrences(objectIntProcedure);
    }

    public boolean anySatisfyWithOccurrences(ObjectIntPredicate<? super T> predicate) {
        return this.getMutableBag().anySatisfyWithOccurrences(predicate);
    }

    public boolean allSatisfyWithOccurrences(ObjectIntPredicate<? super T> predicate) {
        return this.getMutableBag().allSatisfyWithOccurrences(predicate);
    }

    public boolean noneSatisfyWithOccurrences(ObjectIntPredicate<? super T> predicate) {
        return this.getMutableBag().noneSatisfyWithOccurrences(predicate);
    }

    public T detectWithOccurrences(ObjectIntPredicate<? super T> predicate) {
        return (T)this.getMutableBag().detectWithOccurrences(predicate);
    }

    public <V, R extends Collection<V>> R collectWithOccurrences(ObjectIntToObjectFunction<? super T, ? extends V> function, R target) {
        return (R)this.getMutableBag().collectWithOccurrences(function, target);
    }

    public MutableMap<T, Integer> toMapOfItemToCount() {
        return this.getMutableBag().toMapOfItemToCount();
    }

    @Override
    @Deprecated
    public <S> MutableBag<Pair<T, S>> zip(Iterable<S> that) {
        return this.getMutableBag().zip(that);
    }

    @Override
    @Deprecated
    public MutableSet<Pair<T, Integer>> zipWithIndex() {
        return this.getMutableBag().zipWithIndex();
    }

    @Override
    public MutableBag<T> with(T element) {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableBag<T> without(T element) {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    public MutableBag<T> withOccurrences(T element, int occurrences) {
        throw new UnsupportedOperationException("Cannot call withOccurrences() on " + this.getClass().getSimpleName());
    }

    public MutableBag<T> withoutOccurrences(T element, int occurrences) {
        throw new UnsupportedOperationException("Cannot call withoutOccurrences() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableBag<T> withAll(Iterable<? extends T> elements) {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableBag<T> withoutAll(Iterable<? extends T> elements) {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    protected Object writeReplace() {
        return new UnmodifiableBagSerializationProxy<T>(this.getMutableBag());
    }

    public MutableSet<T> selectUnique() {
        return this.getMutableBag().selectUnique();
    }

    @Override
    public <V> MutableObjectLongMap<V> sumByInt(Function<? super T, ? extends V> groupBy, IntFunction<? super T> function) {
        MutableObjectLongMap result = ObjectLongMaps.mutable.empty();
        this.forEachWithOccurrences((ObjectIntProcedure & Serializable)(each, occurrences) -> result.addToValue(groupBy.valueOf(each), (long)function.intValueOf(each) * (long)occurrences));
        return result;
    }

    @Override
    public <V> MutableObjectLongMap<V> sumByLong(Function<? super T, ? extends V> groupBy, LongFunction<? super T> function) {
        MutableObjectLongMap result = ObjectLongMaps.mutable.empty();
        this.forEachWithOccurrences((ObjectIntProcedure & Serializable)(each, occurrences) -> result.addToValue(groupBy.valueOf(each), function.longValueOf(each) * (long)occurrences));
        return result;
    }

    public RichIterable<T> distinctView() {
        return this.getMutableBag().distinctView();
    }

    private static class UnmodifiableBagSerializationProxy<T>
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private MutableBag<T> mutableBag;

        public UnmodifiableBagSerializationProxy() {
        }

        private UnmodifiableBagSerializationProxy(MutableBag<T> bag) {
            this.mutableBag = bag;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            try {
                out.writeObject(this.mutableBag);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.mutableBag = (MutableBag)in.readObject();
        }

        protected Object readResolve() {
            return this.mutableBag.asUnmodifiable();
        }
    }
}

