/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatIntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.FloatIntMap;
import org.eclipse.collections.api.map.primitive.ImmutableFloatIntMap;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.FloatIntPair;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.iterator.ImmutableEmptyIntIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.primitive.LazyFloatIterate;

/**
 * ImmutableFloatIntEmptyMap is an optimization for {@link ImmutableFloatIntMap} of size 0.
 * This file was automatically generated from template file immutablePrimitivePrimitiveEmptyMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableFloatIntEmptyMap implements ImmutableFloatIntMap, Serializable
{
    static final ImmutableFloatIntMap INSTANCE = new ImmutableFloatIntEmptyMap();

    private static final long serialVersionUID = 1L;
    private static final int EMPTY_VALUE = 0;

    private Object readResolve()
    {
        return INSTANCE;
    }

    public int get(float key)
    {
        return EMPTY_VALUE;
    }

    public int getIfAbsent(float key, int ifAbsent)
    {
        return ifAbsent;
    }

    public int getOrThrow(float key)
    {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(float key)
    {
        return false;
    }

    public boolean containsValue(int value)
    {
        return false;
    }

    public void forEachValue(IntProcedure procedure)
    {
    }

    public void forEachKey(FloatProcedure procedure)
    {
    }

    public void forEachKeyValue(FloatIntProcedure procedure)
    {
    }

    public LazyFloatIterable keysView()
    {
        return LazyFloatIterate.empty();
    }

    public RichIterable<FloatIntPair> keyValuesView()
    {
        return LazyIterate.empty();
    }

    public ImmutableFloatIntMap select(FloatIntPredicate predicate)
    {
        return this;
    }

    public ImmutableFloatIntMap reject(FloatIntPredicate predicate)
    {
        return this;
    }

    public ImmutableFloatIntMap toImmutable()
    {
        return this;
    }

    public IntIterator intIterator()
    {
        return ImmutableEmptyIntIterator.INSTANCE;
    }

    public void forEach(IntProcedure procedure)
    {
    }

    /**
     * @since 7.0.
     */
    public void each(IntProcedure procedure)
    {
    }

    public int count(IntPredicate predicate)
    {
        return 0;
    }

    public long sum()
    {
        return 0L;
    }

    public int min()
    {
        throw new NoSuchElementException();
    }

    public int max()
    {
        throw new NoSuchElementException();
    }

    public int maxIfEmpty(int defaultValue)
    {
        return defaultValue;
    }

    public int minIfEmpty(int defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public int[] toSortedArray()
    {
        return new int[0];
    }

    public MutableIntList toSortedList()
    {
        return new IntArrayList();
    }

    public boolean anySatisfy(IntPredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(IntPredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(IntPredicate predicate)
    {
        return true;
    }

    public ImmutableIntCollection select(IntPredicate predicate)
    {
        return IntLists.immutable.with();
    }

    public ImmutableIntCollection reject(IntPredicate predicate)
    {
        return IntLists.immutable.with();
    }

    public int detectIfNone(IntPredicate predicate, int ifNone)
    {
        return ifNone;
    }

    public <V> ImmutableCollection<V> collect(IntToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of();
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    public int[] toArray()
    {
        return new int[0];
    }

    public boolean contains(int value)
    {
        return false;
    }

    public boolean containsAll(int... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(IntIterable source)
    {
        return source.isEmpty();
    }

    public MutableIntList toList()
    {
        return new IntArrayList();
    }

    public MutableIntSet toSet()
    {
        return new IntHashSet();
    }

    public MutableIntBag toBag()
    {
        return new IntHashBag();
    }

    public LazyIntIterable asLazy()
    {
        return new LazyIntIterableAdapter(this);
    }

    public ImmutableFloatIntMap newWithKeyValue(float key, int value)
    {
        return new ImmutableFloatIntSingletonMap(key, value);
    }

    public ImmutableFloatIntMap newWithoutKey(float key)
    {
        return this;
    }

    public ImmutableFloatIntMap newWithoutAllKeys(FloatIterable keys)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public MutableFloatSet keySet()
    {
        return UnmodifiableFloatSet.of(new FloatHashSet());
    }

    public MutableIntCollection values()
    {
        return UnmodifiableIntCollection.of(new IntArrayList());
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof FloatIntMap))
        {
            return false;
        }
        FloatIntMap map = (FloatIntMap) obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    @Override
    public String toString()
    {
        return "{}";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
