/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.factory.set.primitive.ImmutableIntSetFactory;
import org.eclipse.collections.api.set.primitive.ImmutableIntSet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableIntEmptySet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableIntSingletonSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;

public class ImmutableIntSetFactoryImpl
implements ImmutableIntSetFactory {
    public ImmutableIntSet empty() {
        return ImmutableIntEmptySet.INSTANCE;
    }

    public ImmutableIntSet of() {
        return this.empty();
    }

    public ImmutableIntSet with() {
        return this.empty();
    }

    public ImmutableIntSet of(int one) {
        return this.with(one);
    }

    public ImmutableIntSet with(int one) {
        return new ImmutableIntSingletonSet(one);
    }

    public ImmutableIntSet of(int ... items) {
        return this.with(items);
    }

    public ImmutableIntSet with(int ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return IntHashSet.newSetWith(items).toImmutable();
    }

    public ImmutableIntSet ofAll(IntIterable items) {
        return this.withAll(items);
    }

    public ImmutableIntSet withAll(IntIterable items) {
        if (items instanceof ImmutableIntSet) {
            return (ImmutableIntSet)items;
        }
        return this.with(items.toArray());
    }
}

