/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.list.immutable.primitive;

import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.factory.list.primitive.ImmutableIntListFactory;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;

/**
 * ImmutableIntListFactoryImpl is a factory implementation which creates instances of type {@link ImmutableIntList}.
 * This file was automatically generated from template file immutablePrimitiveListFactoryImpl.stg.
 *
 * @since 3.2.
 */
public class ImmutableIntListFactoryImpl implements ImmutableIntListFactory
{
    public ImmutableIntList empty()
    {
        return ImmutableIntEmptyList.INSTANCE;
    }

    public ImmutableIntList of()
    {
        return this.empty();
    }

    public ImmutableIntList with()
    {
        return this.empty();
    }

    public ImmutableIntList of(int one)
    {
        return this.with(one);
    }

    public ImmutableIntList with(int one)
    {
        return new ImmutableIntSingletonList(one);
    }

    public ImmutableIntList of(int... items)
    {
        return this.with(items);
    }

    public ImmutableIntList with(int... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableIntArrayList.newListWith(items);
    }

    public ImmutableIntList ofAll(IntIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableIntList withAll(IntIterable items)
    {
        if (items instanceof ImmutableIntList)
        {
            return (ImmutableIntList) items;
        }
        return this.with(items.toArray());
    }
}
