/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.list.immutable.primitive;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.factory.list.primitive.ImmutableShortListFactory;
import org.eclipse.collections.api.list.primitive.ImmutableShortList;

/**
 * ImmutableShortListFactoryImpl is a factory implementation which creates instances of type {@link ImmutableShortList}.
 * This file was automatically generated from template file immutablePrimitiveListFactoryImpl.stg.
 *
 * @since 3.2.
 */
public class ImmutableShortListFactoryImpl implements ImmutableShortListFactory
{
    public ImmutableShortList empty()
    {
        return ImmutableShortEmptyList.INSTANCE;
    }

    public ImmutableShortList of()
    {
        return this.empty();
    }

    public ImmutableShortList with()
    {
        return this.empty();
    }

    public ImmutableShortList of(short one)
    {
        return this.with(one);
    }

    public ImmutableShortList with(short one)
    {
        return new ImmutableShortSingletonList(one);
    }

    public ImmutableShortList of(short... items)
    {
        return this.with(items);
    }

    public ImmutableShortList with(short... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableShortArrayList.newListWith(items);
    }

    public ImmutableShortList ofAll(ShortIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableShortList withAll(ShortIterable items)
    {
        if (items instanceof ImmutableShortList)
        {
            return (ImmutableShortList) items;
        }
        return this.with(items.toArray());
    }
}
