/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.list.mutable.primitive;

import java.util.Collection;
import java.util.Collections;

import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.procedure.primitive.BooleanIntProcedure;
import org.eclipse.collections.api.iterator.BooleanIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.BooleanList;
import org.eclipse.collections.api.list.primitive.ImmutableBooleanList;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.impl.collection.mutable.primitive.AbstractSynchronizedBooleanCollection;
import org.eclipse.collections.impl.factory.primitive.BooleanLists;
import org.eclipse.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseBooleanIterable;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/**
 * A synchronized view of a {@link MutableBooleanList}. It is imperative that the user manually synchronize on the collection when iterating over it using the
 * {@link BooleanIterator}, as per {@link Collections#synchronizedCollection(Collection)}.
 * <p>
 * This file was automatically generated from template file synchronizedPrimitiveList.stg.
 *
 * @see MutableBooleanList#asSynchronized()
 * @see MutableList#asSynchronized()
 * @since 3.1.
 */
@ThreadSafe
public final class SynchronizedBooleanList
        extends AbstractSynchronizedBooleanCollection
        implements MutableBooleanList
{
    private static final long serialVersionUID = 1L;

    SynchronizedBooleanList(MutableBooleanList list)
    {
        super(list);
    }

    SynchronizedBooleanList(MutableBooleanList list, Object newLock)
    {
        super(list, newLock);
    }

    @GuardedBy("getLock()")
    private MutableBooleanList getMutableBooleanList()
    {
        return (MutableBooleanList) this.getBooleanCollection();
    }

    public boolean get(int index)
    {
        synchronized (this.getLock())
        {
            return this.getMutableBooleanList().get(index);
        }
    }

    public boolean getFirst()
    {
        synchronized (this.getLock())
        {
            return this.getMutableBooleanList().getFirst();
        }
    }

    public boolean getLast()
    {
        synchronized (this.getLock())
        {
            return this.getMutableBooleanList().getLast();
        }
    }

    public int indexOf(boolean value)
    {
        synchronized (this.getLock())
        {
            return this.getMutableBooleanList().indexOf(value);
        }
    }

    public int lastIndexOf(boolean value)
    {
        synchronized (this.getLock())
        {
            return this.getMutableBooleanList().lastIndexOf(value);
        }
    }

    public void addAtIndex(int index, boolean element)
    {
        synchronized (this.getLock())
        {
            this.getMutableBooleanList().addAtIndex(index, element);
        }
    }

    public boolean addAllAtIndex(int index, boolean... source)
    {
        synchronized (this.getLock())
        {
            return this.getMutableBooleanList().addAllAtIndex(index, source);
        }
    }

    public boolean addAllAtIndex(int index, BooleanIterable source)
    {
        synchronized (this.getLock())
        {
            return this.getMutableBooleanList().addAllAtIndex(index, source);
        }
    }

    public boolean removeAtIndex(int index)
    {
        synchronized (this.getLock())
        {
            return this.getMutableBooleanList().removeAtIndex(index);
        }
    }

    public boolean set(int index, boolean element)
    {
        synchronized (this.getLock())
        {
            return this.getMutableBooleanList().set(index, element);
        }
    }

    @Override
    public SynchronizedBooleanList with(boolean element)
    {
        synchronized (this.getLock())
        {
            this.getMutableBooleanList().add(element);
        }
        return this;
    }

    @Override
    public SynchronizedBooleanList without(boolean element)
    {
        synchronized (this.getLock())
        {
            this.getMutableBooleanList().remove(element);
        }
        return this;
    }

    @Override
    public SynchronizedBooleanList withAll(BooleanIterable elements)
    {
        synchronized (this.getLock())
        {
            this.getMutableBooleanList().addAll(elements.toArray());
        }
        return this;
    }

    @Override
    public SynchronizedBooleanList withoutAll(BooleanIterable elements)
    {
        synchronized (this.getLock())
        {
            this.getMutableBooleanList().removeAll(elements);
        }
        return this;
    }

    @Override
    public MutableBooleanList select(BooleanPredicate predicate)
    {
        synchronized (this.getLock())
        {
            return this.getMutableBooleanList().select(predicate);
        }
    }

    @Override
    public MutableBooleanList reject(BooleanPredicate predicate)
    {
        synchronized (this.getLock())
        {
            return this.getMutableBooleanList().reject(predicate);
        }
    }

    @Override
    public <V> MutableList<V> collect(BooleanToObjectFunction<? extends V> function)
    {
        synchronized (this.getLock())
        {
            return this.getMutableBooleanList().collect(function);
        }
    }

    @Override
    public boolean equals(Object otherList)
    {
        synchronized (this.getLock())
        {
            return this.getMutableBooleanList().equals(otherList);
        }
    }

    @Override
    public int hashCode()
    {
        synchronized (this.getLock())
        {
            return this.getMutableBooleanList().hashCode();
        }
    }

    @Override
    public LazyBooleanIterable asLazy()
    {
        synchronized (this.getLock())
        {
            return new LazyBooleanIterableAdapter(this);
        }
    }

    @Override
    public MutableBooleanList asUnmodifiable()
    {
        return new UnmodifiableBooleanList(this);
    }

    @Override
    public MutableBooleanList asSynchronized()
    {
        return this;
    }

    @Override
    public ImmutableBooleanList toImmutable()
    {
        synchronized (this.getLock())
        {
            int size = this.size();
            if (size == 0)
            {
                return BooleanLists.immutable.with();
            }
            if (size == 1)
            {
                return BooleanLists.immutable.with(this.getFirst());
            }
            return BooleanLists.immutable.with(this.toArray());
        }
    }

    public MutableBooleanList reverseThis()
    {
        synchronized (this.getLock())
        {
            this.getMutableBooleanList().reverseThis();
        }
        return this;
    }

    public MutableBooleanList toReversed()
    {
        synchronized (this.getLock())
        {
            return this.getMutableBooleanList().toReversed();
        }
    }

    public LazyBooleanIterable asReversed()
    {
        return ReverseBooleanIterable.adapt(this);
    }

    public void forEachWithIndex(BooleanIntProcedure procedure)
    {
        synchronized (this.getLock())
        {
            this.getMutableBooleanList().forEachWithIndex(procedure);
        }
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectBooleanIntToObjectFunction<? super T, ? extends T> function)
    {
        synchronized (this.getLock())
        {
            return this.getMutableBooleanList().injectIntoWithIndex(injectedValue, function);
        }
    }

    /**
     * @since 6.0.
     */
    public MutableBooleanList distinct()
    {
        synchronized (this.getLock())
        {
            return this.getMutableBooleanList().distinct();
        }
    }

    public MutableBooleanList subList(int fromIndex, int toIndex)
    {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}
