/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.list.mutable.primitive;

import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.procedure.primitive.BooleanIntProcedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.BooleanList;
import org.eclipse.collections.api.list.primitive.ImmutableBooleanList;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.impl.collection.mutable.primitive.AbstractUnmodifiableBooleanCollection;
import org.eclipse.collections.impl.factory.primitive.BooleanLists;
import org.eclipse.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseBooleanIterable;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveList.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableBooleanList
        extends AbstractUnmodifiableBooleanCollection
        implements MutableBooleanList
{
    private static final long serialVersionUID = 1L;

    UnmodifiableBooleanList(MutableBooleanList list)
    {
        super(list);
    }

    private MutableBooleanList getMutableBooleanList()
    {
        return (MutableBooleanList) this.getBooleanCollection();
    }

    public boolean get(int index)
    {
        return this.getMutableBooleanList().get(index);
    }

    public boolean getFirst()
    {
        return this.getMutableBooleanList().getFirst();
    }

    public boolean getLast()
    {
        return this.getMutableBooleanList().getLast();
    }

    public int indexOf(boolean value)
    {
        return this.getMutableBooleanList().indexOf(value);
    }

    public int lastIndexOf(boolean value)
    {
        return this.getMutableBooleanList().lastIndexOf(value);
    }

    public void addAtIndex(int index, boolean element)
    {
        throw new UnsupportedOperationException("Cannot call addAtIndex() on " + this.getClass().getSimpleName());
    }

    public boolean addAllAtIndex(int index, boolean... source)
    {
        throw new UnsupportedOperationException("Cannot call addAllAtIndex() on " + this.getClass().getSimpleName());
    }

    public boolean addAllAtIndex(int index, BooleanIterable source)
    {
        throw new UnsupportedOperationException("Cannot call addAllAtIndex() on " + this.getClass().getSimpleName());
    }

    public boolean removeAtIndex(int index)
    {
        throw new UnsupportedOperationException("Cannot call removeAtIndex() on " + this.getClass().getSimpleName());
    }

    public boolean set(int index, boolean element)
    {
        throw new UnsupportedOperationException("Cannot call set() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableBooleanList with(boolean element)
    {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableBooleanList without(boolean element)
    {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableBooleanList withAll(BooleanIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableBooleanList withoutAll(BooleanIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableBooleanList select(BooleanPredicate predicate)
    {
        return this.getMutableBooleanList().select(predicate);
    }

    @Override
    public MutableBooleanList reject(BooleanPredicate predicate)
    {
        return this.getMutableBooleanList().reject(predicate);
    }

    @Override
    public <V> MutableList<V> collect(BooleanToObjectFunction<? extends V> function)
    {
        return this.getMutableBooleanList().collect(function);
    }

    @Override
    public boolean equals(Object otherList)
    {
        return this.getMutableBooleanList().equals(otherList);
    }

    @Override
    public int hashCode()
    {
        return this.getMutableBooleanList().hashCode();
    }

    @Override
    public MutableBooleanList asUnmodifiable()
    {
        return this;
    }

    @Override
    public MutableBooleanList asSynchronized()
    {
        return new SynchronizedBooleanList(this);
    }

    @Override
    public ImmutableBooleanList toImmutable()
    {
        int size = this.size();
        if (size == 0)
        {
            return BooleanLists.immutable.with();
        }
        if (size == 1)
        {
            return BooleanLists.immutable.with(this.getFirst());
        }
        return BooleanLists.immutable.with(this.toArray());
    }

    public MutableBooleanList reverseThis()
    {
        throw new UnsupportedOperationException("Cannot call reverseThis() on " + this.getClass().getSimpleName());
    }

    public MutableBooleanList toReversed()
    {
        return this.getMutableBooleanList().toReversed();
    }

    public void forEachWithIndex(BooleanIntProcedure procedure)
    {
        this.getMutableBooleanList().forEachWithIndex(procedure);
    }

    public LazyBooleanIterable asReversed()
    {
        return ReverseBooleanIterable.adapt(this);
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectBooleanIntToObjectFunction<? super T, ? extends T> function)
    {
        return this.getMutableBooleanList().injectIntoWithIndex(injectedValue, function);
    }

    /**
     * @since 6.0.
     */
    public MutableBooleanList distinct()
    {
        return this.getMutableBooleanList().distinct();
    }

    public MutableBooleanList subList(int fromIndex, int toIndex)
    {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}
