/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.list.mutable.primitive;

import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteIntProcedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.ByteList;
import org.eclipse.collections.api.list.primitive.ImmutableByteList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.impl.collection.mutable.primitive.AbstractUnmodifiableByteCollection;
import org.eclipse.collections.impl.factory.primitive.ByteLists;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseByteIterable;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveList.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableByteList
        extends AbstractUnmodifiableByteCollection
        implements MutableByteList
{
    private static final long serialVersionUID = 1L;

    UnmodifiableByteList(MutableByteList list)
    {
        super(list);
    }

    private MutableByteList getMutableByteList()
    {
        return (MutableByteList) this.getByteCollection();
    }

    public byte get(int index)
    {
        return this.getMutableByteList().get(index);
    }

    public byte getFirst()
    {
        return this.getMutableByteList().getFirst();
    }

    public byte getLast()
    {
        return this.getMutableByteList().getLast();
    }

    public int indexOf(byte value)
    {
        return this.getMutableByteList().indexOf(value);
    }

    public int lastIndexOf(byte value)
    {
        return this.getMutableByteList().lastIndexOf(value);
    }

    public void addAtIndex(int index, byte element)
    {
        throw new UnsupportedOperationException("Cannot call addAtIndex() on " + this.getClass().getSimpleName());
    }

    public boolean addAllAtIndex(int index, byte... source)
    {
        throw new UnsupportedOperationException("Cannot call addAllAtIndex() on " + this.getClass().getSimpleName());
    }

    public boolean addAllAtIndex(int index, ByteIterable source)
    {
        throw new UnsupportedOperationException("Cannot call addAllAtIndex() on " + this.getClass().getSimpleName());
    }

    public byte removeAtIndex(int index)
    {
        throw new UnsupportedOperationException("Cannot call removeAtIndex() on " + this.getClass().getSimpleName());
    }

    public byte set(int index, byte element)
    {
        throw new UnsupportedOperationException("Cannot call set() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableByteList with(byte element)
    {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableByteList without(byte element)
    {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableByteList withAll(ByteIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableByteList withoutAll(ByteIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableByteList select(BytePredicate predicate)
    {
        return this.getMutableByteList().select(predicate);
    }

    @Override
    public MutableByteList reject(BytePredicate predicate)
    {
        return this.getMutableByteList().reject(predicate);
    }

    @Override
    public <V> MutableList<V> collect(ByteToObjectFunction<? extends V> function)
    {
        return this.getMutableByteList().collect(function);
    }

    public MutableByteList sortThis()
    {
        throw new UnsupportedOperationException("Cannot call sortThis() on " + this.getClass().getSimpleName());
    }

    public int binarySearch(byte value)
    {
        return this.getMutableByteList().binarySearch(value);
    }

    public long dotProduct(ByteList list)
    {
        return this.getMutableByteList().dotProduct(list);
    }

    @Override
    public boolean equals(Object otherList)
    {
        return this.getMutableByteList().equals(otherList);
    }

    @Override
    public int hashCode()
    {
        return this.getMutableByteList().hashCode();
    }

    @Override
    public MutableByteList asUnmodifiable()
    {
        return this;
    }

    @Override
    public MutableByteList asSynchronized()
    {
        return new SynchronizedByteList(this);
    }

    @Override
    public ImmutableByteList toImmutable()
    {
        int size = this.size();
        if (size == 0)
        {
            return ByteLists.immutable.with();
        }
        if (size == 1)
        {
            return ByteLists.immutable.with(this.getFirst());
        }
        return ByteLists.immutable.with(this.toArray());
    }

    public MutableByteList reverseThis()
    {
        throw new UnsupportedOperationException("Cannot call reverseThis() on " + this.getClass().getSimpleName());
    }

    public MutableByteList toReversed()
    {
        return this.getMutableByteList().toReversed();
    }

    public void forEachWithIndex(ByteIntProcedure procedure)
    {
        this.getMutableByteList().forEachWithIndex(procedure);
    }

    public LazyByteIterable asReversed()
    {
        return ReverseByteIterable.adapt(this);
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectByteIntToObjectFunction<? super T, ? extends T> function)
    {
        return this.getMutableByteList().injectIntoWithIndex(injectedValue, function);
    }

    /**
     * @since 6.0.
     */
    public MutableByteList distinct()
    {
        return this.getMutableByteList().distinct();
    }

    public MutableByteList subList(int fromIndex, int toIndex)
    {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}
