/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Set;

import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ObjectDoublePredicate;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectDoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.map.primitive.ImmutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.ObjectDoubleMap;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.tuple.primitive.ObjectDoublePair;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableDoubleCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.factory.primitive.DoubleLists;
import org.eclipse.collections.impl.iterator.ImmutableEmptyDoubleIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;
import org.eclipse.collections.impl.utility.LazyIterate;

/**
 * ImmutableObjectDoubleEmptyMap is an optimization for {@link ImmutableObjectDoubleMap} of size 0.
 * This file was automatically generated from template file immutableObjectPrimitiveEmptyMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableObjectDoubleEmptyMap<K> implements ImmutableObjectDoubleMap<K>, Serializable
{
    static final ImmutableObjectDoubleMap<?> INSTANCE = new ImmutableObjectDoubleEmptyMap<Object>();

    private static final long serialVersionUID = 1L;
    private static final double EMPTY_VALUE = 0.0;

    private Object readResolve()
    {
        return INSTANCE;
    }

    public DoubleIterator doubleIterator()
    {
        return ImmutableEmptyDoubleIterator.INSTANCE;
    }

    public void forEach(DoubleProcedure procedure)
    {
    }

    /**
     * @since 7.0.
     */
    public void each(DoubleProcedure procedure)
    {
    }

    public int count(DoublePredicate predicate)
    {
        return 0;
    }

    public boolean anySatisfy(DoublePredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(DoublePredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(DoublePredicate predicate)
    {
        return true;
    }

    public ImmutableDoubleCollection select(DoublePredicate predicate)
    {
        return DoubleLists.immutable.with();
    }

    public ImmutableDoubleCollection reject(DoublePredicate predicate)
    {
        return DoubleLists.immutable.with();
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone)
    {
        return ifNone;
    }

    public <V> ImmutableCollection<V> collect(DoubleToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of();
    }

    public double sum()
    {
        return 0.0;
    }

    public double min()
    {
        throw new NoSuchElementException();
    }

    public double max()
    {
        throw new NoSuchElementException();
    }

    public double maxIfEmpty(double defaultValue)
    {
        return defaultValue;
    }

    public double minIfEmpty(double defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public double[] toSortedArray()
    {
        return new double[0];
    }

    public MutableDoubleList toSortedList()
    {
        return new DoubleArrayList();
    }

    public double[] toArray()
    {
        return new double[0];
    }

    public boolean contains(double value)
    {
        return false;
    }

    public boolean containsAll(double... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(DoubleIterable source)
    {
        return source.isEmpty();
    }

    public MutableDoubleList toList()
    {
        return new DoubleArrayList();
    }

    public MutableDoubleSet toSet()
    {
        return new DoubleHashSet();
    }

    public MutableDoubleBag toBag()
    {
        return new DoubleHashBag();
    }

    public LazyDoubleIterable asLazy()
    {
        return new LazyDoubleIterableAdapter(this);
    }

    public ImmutableObjectDoubleMap<K> newWithKeyValue(K key, double value)
    {
        return new ImmutableObjectDoubleSingletonMap<K>(key, value);
    }

    public ImmutableObjectDoubleMap<K> newWithoutKey(K key)
    {
        return this;
    }

    public ImmutableObjectDoubleMap<K> newWithoutAllKeys(Iterable<? extends K> keys)
    {
        return this;
    }

    public double get(Object key)
    {
        return EMPTY_VALUE;
    }

    public double getOrThrow(Object key)
    {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public double getIfAbsent(Object key, double ifAbsent)
    {
        return ifAbsent;
    }

    public boolean containsKey(Object key)
    {
        return false;
    }

    public boolean containsValue(double value)
    {
        return false;
    }

    public void forEachValue(DoubleProcedure procedure)
    {
    }

    public void forEachKey(Procedure<? super K> procedure)
    {
    }

    public void forEachKeyValue(ObjectDoubleProcedure<? super K> objectDoubleProcedure)
    {
    }

    public ImmutableObjectDoubleMap<K> select(ObjectDoublePredicate<? super K> objectDoublePredicate)
    {
        return this;
    }

    public ImmutableObjectDoubleMap<K> reject(ObjectDoublePredicate<? super K> objectDoublePredicate)
    {
        return this;
    }

    public ImmutableObjectDoubleMap<K> toImmutable()
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    public Set<K> keySet()
    {
        return Sets.immutable.<K>of().castToSet();
    }

    public MutableDoubleCollection values()
    {
        return UnmodifiableDoubleCollection.of(new DoubleArrayList());
    }

    public LazyIterable<K> keysView()
    {
        return LazyIterate.empty();
    }

    public RichIterable<ObjectDoublePair<K>> keyValuesView()
    {
        return LazyIterate.empty();
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof ObjectDoubleMap))
        {
            return false;
        }
        ObjectDoubleMap<K> map = (ObjectDoubleMap<K>) obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    @Override
    public String toString()
    {
        return "{}";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
