/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.bag.primitive.ImmutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortBytePredicate;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.map.primitive.ShortByteMap;
import org.eclipse.collections.api.map.primitive.ImmutableShortByteMap;
import org.eclipse.collections.api.map.primitive.MutableShortByteMap;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.tuple.primitive.ShortBytePair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedShortByteProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import org.eclipse.collections.impl.iterator.UnmodifiableByteIterator;
import org.eclipse.collections.impl.map.mutable.primitive.ShortByteHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableShortSet;

/**
 * ImmutableShortByteHashMap is the non-modifiable equivalent of {@link ShortByteHashMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveHashMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableShortByteHashMap implements ImmutableShortByteMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableShortByteMap delegate;

    ImmutableShortByteHashMap(ShortByteMap delegate)
    {
        this.delegate = new ShortByteHashMap(delegate);
    }

    public byte get(short key)
    {
        return this.delegate.get(key);
    }

    public byte getIfAbsent(short key, byte ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public byte getOrThrow(short key)
    {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(short key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(byte value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(ByteProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(ShortProcedure procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(ShortByteProcedure procedure)
    {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyShortIterable keysView()
    {
        return this.delegate.keysView();
    }

    public RichIterable<ShortBytePair> keyValuesView()
    {
        return this.delegate.keyValuesView();
    }

    public ImmutableShortByteMap select(ShortBytePredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableShortByteMap reject(ShortBytePredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function)
    {
        return this.delegate.injectInto(injectedValue, function);
    }

    public ImmutableShortByteMap toImmutable()
    {
        return this;
    }

    public ByteIterator byteIterator()
    {
        return new UnmodifiableByteIterator(this.delegate.byteIterator());
    }

    public void forEach(ByteProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(ByteProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(BytePredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(BytePredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(BytePredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BytePredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableByteBag select(BytePredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableByteBag reject(BytePredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <V> ImmutableBag<V> collect(ByteToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public long sum()
    {
        return this.delegate.sum();
    }

    public byte max()
    {
        return this.delegate.max();
    }

    public byte maxIfEmpty(byte defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public byte min()
    {
        return this.delegate.min();
    }

    public byte minIfEmpty(byte defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public byte[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }

    public MutableByteList toSortedList()
    {
        return this.delegate.toSortedList();
    }

    public byte[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(byte value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(byte... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(ByteIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableByteList toList()
    {
        return this.delegate.toList();
    }

    public MutableByteSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableByteBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyByteIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableShortByteMap newWithKeyValue(short key, byte value)
    {
        MutableShortByteMap map = new ShortByteHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableShortByteMap newWithoutKey(short key)
    {
        MutableShortByteMap map = new ShortByteHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableShortByteMap newWithoutAllKeys(ShortIterable keys)
    {
        MutableShortByteMap map = new ShortByteHashMap(this.size());
        map.putAll(this);
        ShortIterator iterator = keys.shortIterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableShortSet keySet()
    {
        return UnmodifiableShortSet.of(this.delegate.keySet());
    }

    public MutableByteCollection values()
    {
        return UnmodifiableByteCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    private Object writeReplace()
    {
        return new ImmutableShortByteMapSerializationProxy(this);
    }

    protected static class ImmutableShortByteMapSerializationProxy implements Externalizable
    {
        private static final long serialVersionUID = 1L;

        private ShortByteMap map;

        @SuppressWarnings("UnusedDeclaration")
        public ImmutableShortByteMapSerializationProxy()
        {
            // Empty constructor for Externalizable class
        }

        protected ImmutableShortByteMapSerializationProxy(ShortByteMap map)
        {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException
        {
            out.writeInt(this.map.size());
            try
            {
                this.map.forEachKeyValue(new CheckedShortByteProcedure()
                {
                    @Override
                    public void safeValue(short key, byte value) throws IOException
                    {
                        out.writeShort(key);
                        out.writeByte(value);
                    }
                });
            }
            catch (RuntimeException e)
            {
                if (e.getCause() instanceof IOException)
                {
                    throw (IOException) e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
        {
            int size = in.readInt();
            MutableShortByteMap deserializedMap = new ShortByteHashMap();

            for (int i = 0; i < size; i++)
            {
                deserializedMap.put(in.readShort(), in.readByte());
            }

            this.map = deserializedMap;
        }

        protected Object readResolve()
        {
            return this.map.toImmutable();
        }
    }
}
