/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.mutable.primitive;

import org.eclipse.collections.api.factory.map.primitive.MutableFloatCharMapFactory;
import org.eclipse.collections.api.map.primitive.MutableFloatCharMap;
import org.eclipse.collections.api.map.primitive.FloatCharMap;

/**
 * MutableFloatCharMapFactoryImpl is a factory implementation which creates instances of type {@link MutableFloatCharMap}.
 * This file was automatically generated from template file mutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableFloatCharMapFactoryImpl implements MutableFloatCharMapFactory
{
    public MutableFloatCharMap empty()
    {
        return new FloatCharHashMap(0);
    }

    public MutableFloatCharMap of()
    {
        return this.empty();
    }

    public MutableFloatCharMap with()
    {
        return this.empty();
    }

    public MutableFloatCharMap ofAll(FloatCharMap map)
    {
        return this.withAll(map);
    }

    public MutableFloatCharMap withAll(FloatCharMap map)
    {
        if (map.isEmpty())
        {
            return this.empty();
        }
        return new FloatCharHashMap(map);
    }
}
