/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.set.immutable.primitive;

import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.set.primitive.ImmutableByteSet;
import org.eclipse.collections.api.set.primitive.ByteSet;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.set.primitive.AbstractByteSet;

/**
 * This file was automatically generated from template file abstractImmutablePrimitiveSet.stg.
 *
 * @since 6.0.
 */
public abstract class AbstractImmutableByteSet extends AbstractByteSet implements ImmutableByteSet
{
    public ImmutableByteSet newWith(byte element)
    {
        return ByteHashSet.newSet(this).with(element).toImmutable();
    }

    public ImmutableByteSet newWithout(byte element)
    {
        return ByteHashSet.newSet(this).without(element).toImmutable();
    }

    public ImmutableByteSet newWithAll(ByteIterable elements)
    {
        return ByteHashSet.newSet(this).withAll(elements).toImmutable();
    }

    public ImmutableByteSet newWithoutAll(ByteIterable elements)
    {
        return ByteHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    public ByteSet freeze()
    {
        return this;
    }

    public ImmutableByteSet toImmutable()
    {
        return this;
    }
}
