/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.set.immutable.primitive;

import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.set.primitive.ImmutableCharSet;
import org.eclipse.collections.api.set.primitive.CharSet;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import org.eclipse.collections.impl.set.primitive.AbstractCharSet;

/**
 * This file was automatically generated from template file abstractImmutablePrimitiveSet.stg.
 *
 * @since 6.0.
 */
public abstract class AbstractImmutableCharSet extends AbstractCharSet implements ImmutableCharSet
{
    public ImmutableCharSet newWith(char element)
    {
        return CharHashSet.newSet(this).with(element).toImmutable();
    }

    public ImmutableCharSet newWithout(char element)
    {
        return CharHashSet.newSet(this).without(element).toImmutable();
    }

    public ImmutableCharSet newWithAll(CharIterable elements)
    {
        return CharHashSet.newSet(this).withAll(elements).toImmutable();
    }

    public ImmutableCharSet newWithoutAll(CharIterable elements)
    {
        return CharHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    public CharSet freeze()
    {
        return this;
    }

    public ImmutableCharSet toImmutable()
    {
        return this;
    }
}
