/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.set.immutable.primitive;

import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.set.primitive.ImmutableDoubleSet;
import org.eclipse.collections.api.set.primitive.DoubleSet;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;
import org.eclipse.collections.impl.set.primitive.AbstractDoubleSet;

/**
 * This file was automatically generated from template file abstractImmutablePrimitiveSet.stg.
 *
 * @since 6.0.
 */
public abstract class AbstractImmutableDoubleSet extends AbstractDoubleSet implements ImmutableDoubleSet
{
    public ImmutableDoubleSet newWith(double element)
    {
        return DoubleHashSet.newSet(this).with(element).toImmutable();
    }

    public ImmutableDoubleSet newWithout(double element)
    {
        return DoubleHashSet.newSet(this).without(element).toImmutable();
    }

    public ImmutableDoubleSet newWithAll(DoubleIterable elements)
    {
        return DoubleHashSet.newSet(this).withAll(elements).toImmutable();
    }

    public ImmutableDoubleSet newWithoutAll(DoubleIterable elements)
    {
        return DoubleHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    public DoubleSet freeze()
    {
        return this;
    }

    public ImmutableDoubleSet toImmutable()
    {
        return this;
    }
}
